//
//  PXILConversion.h
//  PXImageLib
//
//  Created by Aidas Dailide on 2008-11-17.
//  Copyright 2008 Pixelmator Team Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Accelerate/Accelerate.h>


typedef enum PXILReduceBitsTypes
{
	PXILReduceBitsNone,
	PXILReduceBitsStucki,
	PXILReduceBitsFloidSteinberg,
	PXILReduceBitsJJN,
	PXILReduceBitsBayer
} PXILReduceBitsType;

@interface PXILConversion : NSObject {

}
+(PXILConversion *)sharedInstance;
-(BOOL)imageLibConvertARGBtoBGRA:( const vImage_Buffer *)src;
-(BOOL)imageLibAddRandomGaussian:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibAddRandomGaussianInteger:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibAddRandomGaussianFloat:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibReduceBits:( const vImage_Buffer *)dest noise:(int)noise levels:(int)levels reduceType:(PXILReduceBitsType)_type;

-(BOOL)imageLibGetMinimumValuesFromRGBA888:(const vImage_Buffer *)src minValues:(unsigned char *)minValues;

-(BOOL)imageLibCopyRGBA8888:(const vImage_Buffer *)src dest:(const vImage_Buffer *)dest;
-(BOOL)imageLibCopyPlanar8:(const vImage_Buffer *)src dest:(const vImage_Buffer *)dest;

-(BOOL)imageLibCopyPlanar8ToRGBA8888:(const vImage_Buffer *)src dest:(const vImage_Buffer *)dest;

-(BOOL)imageLibMultiplyAndScaleRGBA8888:(const vImage_Buffer *)src dest:(const vImage_Buffer *)dest;
-(BOOL)imageLibMultiplyAndScalePlanar8:(const vImage_Buffer *)src dest:(const vImage_Buffer *)dest;

-(BOOL)imageLibConvertARGBtoBGRA8888:(const vImage_Buffer *)src;
-(BOOL)imageLibSwapChannels:(const vImage_Buffer *)src destination:(const vImage_Buffer *)dest order:(int *)order;

-(BOOL)imageLibInvertBuffer:(vImage_Buffer *)src;

-(BOOL)imageLibThresholdGreaterPlanar:(vImage_Buffer *)src threshold:(unsigned char)threshold newValue:(unsigned char)value;

-(BOOL)imageLibSetPlanar8:(vImage_Buffer *)src toValue:(unsigned char)value;

-(BOOL)imageLibCopyRGBA8888SelectedChannel:(vImage_Buffer *)src toDest:(vImage_Buffer *)dest;


-(BOOL)imageLibAbsDiffBufferOne:(vImage_Buffer *)src1 bufferTwo:(vImage_Buffer *)src2 dest:(vImage_Buffer *)dest;

-(BOOL)imageLibMaxEveryBuffer:(vImage_Buffer *)src toDest:(vImage_Buffer *)dest;
-(BOOL)imageLibSetRGBA8888:(vImage_Buffer *)src toValue:(unsigned char[4])value;
-(BOOL)imageLibMultiplyPlanar8:(vImage_Buffer *)src byValue:(unsigned char)value;

-(BOOL)imageLibGetMinimumValueFromPlanar8:(vImage_Buffer *)src minValue:(unsigned char *)minValue;
-(BOOL)imageLibGetMaximumValueFromPlanar8:(vImage_Buffer *)src maxValue:(unsigned char *)minValue;
@end
