//
//  PXOS_Automator.h
//  PXOpenSave
//
//  Created by Rimas Mickevičius on 2010-03-26.
//  Copyright 2010 Pixelmator Team Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "PXOS_Protocols.h"
#import "PXOS_FileManager.h"

@interface PXOS_Automator : NSObject <PXOS_OpenSaveDelegate>
{
	// temp pxm save
	size_t _pxm_bitsPerComponent;
	size_t _pxm_contextRowBytes;
	unsigned char *_pixelsBuffer;
	//NSData *_colorSyncData;
	NSColorSpace *_fileNSColorSpace;
	CGColorSpaceRef _contextColorSpace;
	
	
	//size_t _pxm_imageWidth;
	//size_t _pxm_imageHeight;
	//size_t _pxm_imageRowBytes;
	
	//NSDictionary *_pxm_propertiesDictionary;
	
	//double _pxm_DPIvalue;
	//int _pxm_DPItype;
	
	//--------------------------------
	// PXM > PSD nesamones
	
	NSMutableArray *_pxm_layers;
	NSMutableDictionary *_pxm_image;
}

-(NSError*)PXOSF_OpenImageAtURL:(NSURL*)URLtoOpen andSaveToURL:(NSURL*)URLtoSave withUTI:(NSString*)destinationUTI;
-(NSString*)PXOSF_fileUTIfromExtension:(NSString*)extension;


-(CGImageRef)PXOSF_CGImageAtURL:(NSURL*)fileURL infoDictionary:(NSDictionary**)infoDict imageUTI:(NSString**)UTIstring readError:(NSError**)rError;
-(void)PXOSF_SaveCGImage:(CGImageRef)imageToSave atURL:(NSURL*)fileURL infoDictionary:(NSDictionary*)infoDict imageUTI:(NSString*)UTIstring writeError:(NSError**)wError;

-(NSError*)PXOSF_OpenPXMAtURL:(NSURL*)pxmURL andSaveToPSDAtURL:(NSURL*)psdURL;

@end
