/*
 *  PXOS_Protocols.h
 *  PXOpenSave
 *
 *  Created by Rimas Mickevičius on 2008-08-18.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#import <Accelerate/Accelerate.h>

// protokolai, kad butu galima naudot PXOSF


//===================================================================================================================================
// ImageIO potokolas. Skirtas pagrindiniu tipu (jpg, png, bmp...) supportui
//-----------------------------------------------------------------------------------------------------------------------------------
@protocol PXOS_OpenSaveDelegate <NSObject>
//----------------------------------------------------------------
// Pateikia info, reikalinga paveiksliuko atidarymui. Jei viskas ok (grazina nil), delegatas turi perimt pixelsBuffer atminti ir lieka uz ja atsakingas. Jei kazkas negerai (grazina kazkoki NSError), pixelsBuffer bus atlaisvintas.
-(NSError*)PXOS_LoadImageWith_width:(size_t)imageWidth height:(size_t)imageHeight bytesPerRow:(size_t)bytesPerRow pixelsBuffer:(unsigned char*)pixelsBuffer colorSyncProfileData:(NSData*)csData filePropertiesDictionary:(NSDictionary*)propDictionary colorSpaceChngedToGenericRGB:(BOOL)changedToGRGB fileIsNotRGB:(BOOL)fileNotRGB;
//----------------------------------------------------------------
//===================================================================================================================================
//===================================================================================================================================
// RAW atidarymui (kolkas 8bit). Naudoja ImageIO
//-----------------------------------------------------------------------------------------------------------------------------------
// Daro ta pati ka ir ankstesnis metodas, tik sukuria nauja dokumenta, o ne atidaro.
-(NSError*)PXOS_LoadRAWImageWith_width:(size_t)imageWidth height:(size_t)imageHeight bytesPerRow:(size_t)bytesPerRow pixelsBuffer:(unsigned char*)pixelsBuffer colorSyncProfileData:(NSData*)csData filePropertiesDictionary:(NSDictionary*)propDictionary colorSpaceChngedToGenericRGB:(BOOL)changedToGRGB fileWasNotRGB:(BOOL)fileWasNotRGB;
//----------------------------------------------------------------
//===================================================================================================================================
// PXM atidarymui
//----------------------------------------------------------------
//-(void)PXOS_CancelImageShouldFitOnSTartup;
//----------------------------------------------------------------
-(NSError*)PXOS_LoadOldPXMImage_ofImageSize:(NSSize)imageSize imageResolution:(float)imageResolution imageResolutionType:(int)resolutionType zoomValue:(float)zoomValue colorsyncProfileData:(NSData*)colorSyncData pxmFileMetaData:(NSDictionary*)fileMetadata documentVisibleRect:(NSRect)documentVisibleRect masksInfo_selection:(NSIndexSet*)masksSelection masksVisibleRect:(NSRect)maskVisibleRect layersInfo_selection:(NSIndexSet*)layersSelection layersVisibleRect:(NSRect)layersVisibleRect;
//----------------------------------------------------------------
-(NSError*)PXOS_OldPXM_addLayerWitInfo_layerName:(NSString*)layerName layerSize:(NSSize)layerSize layerOrigin:(NSPoint)layerOrigin layerOpacity:(int)layerOpacity uniqueID:(NSString*)layerID compositeOp:(int)compositeOp preserveTransparency:(BOOL)preserveTr isClippingLayer:(BOOL)isClipping isVisble:(BOOL)isVisble hasLayerMask:(BOOL)hasLayerMask isEditingLayerMask:(BOOL)isEditingMask layerMaskIsVisble:(BOOL)maskVisble layerRGBApixels:(unsigned char*)rgbaPixels linkedIDs:(NSArray*)linkedids andLayerMaskInfo_size:(NSSize)lm_size lm_rgbaPixels:(unsigned char*)lm_pixels lm_name:(NSString*)lm_name lm_compositeOp:(int)lm_compositeOp lm_isClipping:(BOOL)lm_isClipping lm_opacity:(int)lm_opacity lm_origin:(NSPoint)lm_origin lm_preserveTransparency:(BOOL)lm_preserveTr lm_id:(NSString*)lm_id lm_visible:(BOOL)lm_visible lm_hasLayerMask:(BOOL)lm_hasLayerMask lm_isEditingMask:(BOOL)lm_isEditingMask lm_isLayerMaskVisible:(BOOL)lm_isMaskVisble;
//----------------------------------------------------------------
-(NSError*)PXOS_OldPXM_addTextLayerWitInfo_layerName:(NSString*)layerName layerSize:(NSSize)layerSize layerOrigin:(NSPoint)layerOrigin layerOpacity:(int)layerOpacity uniqueID:(NSString*)layerID compositeOp:(int)compositeOp preserveTransparency:(BOOL)preserveTr isClippingLayer:(BOOL)isClipping isVisble:(BOOL)isVisble hasLayerMask:(BOOL)hasLayerMask isEditingLayerMask:(BOOL)isEditingMask layerMaskIsVisble:(BOOL)maskVisble layerRGBApixels:(unsigned char*)rgbaPixels  textViewFrame:(NSRect)textViewFrame docZoomValue:(float)zoomas layerAttributedString:(NSAttributedString*)layerAttributedString linkedIDs:(NSArray*)linkedids andLayerMaskInfo_size:(NSSize)lm_size lm_rgbaPixels:(unsigned char*)lm_pixels lm_name:(NSString*)lm_name lm_compositeOp:(int)lm_compositeOp lm_isClipping:(BOOL)lm_isClipping lm_opacity:(int)lm_opacity lm_origin:(NSPoint)lm_origin lm_preserveTransparency:(BOOL)lm_preserveTr lm_id:(NSString*)lm_id lm_visible:(BOOL)lm_visible lm_hasLayerMask:(BOOL)lm_hasLayerMask lm_isEditingMask:(BOOL)lm_isEditingMask lm_isLayerMaskVisible:(BOOL)lm_isMaskVisble;
//----------------------------------------------------------------
-(NSError*)PXOS_OldPXM_addMaskWithInfo_size:(NSSize)maskSize maskName:(NSString*)maskName rgbaPixels:(unsigned char*)rgbaMaskPixels maskCompositeOp:(int)maskCompositeOp maskIsClipping:(BOOL)isClipping maskOpacity:(int)maskOpacity maskOrigin:(NSPoint)maskOrigin maskPreserveTrans:(BOOL)preserveTr maskID:(NSString*)maskID maskVisible:(BOOL)maskVisible maskEditingMask:(BOOL)editingMask maskHasLayerMask:(BOOL)hasLayerMask maskLayerMaskVisible:(BOOL)layerMaskVisible;
//------------ naujo PXM atidarymui ----------------
-(NSError*)PXOS_PXM_AddGroupLayer_Name:(NSString*)layerName layerSize:(NSSize)layerSize layerOrigin:(NSPoint)layerOrigin layerOpacity:(int)opacity uniqueID:(NSString*)layerID compositeOp:(int)compositeOp preserveTransparency:(BOOL)preserveTr isClippingLayer:(BOOL)isClipping isVisble:(BOOL)isVisible fileArchitecture:(int)fileArchitecture layerRowBytes:(int)layerRowBytes architectureBytes:(unsigned char*)layerBytes layerCustomInfoDict:(NSDictionary*)layerCustomInfoDict hasLayerMask:(BOOL)hasLayerMask linkedWithMask:(BOOL)linkedWithMask maskVisible:(BOOL)maskVisible isEditingMask:(BOOL)editingMask maskSize:(NSSize)maskSize maskOrigin:(NSPoint)maskOrigin maskName:(NSString*)maskName maskID:(NSString*)maskID maskRowBytes:(int)maskRowBytes maskPixelsDataLength:(long)dataLength maskArchitectureBytes:(unsigned char*)maskPixelsBuffer layerMaskEdgeType:(long)layerMaskEdgeType layerMaskCustomInfoDict:(NSDictionary*)layerMaskCustomInfoDict;
-(NSError*)PXOS_PXM_AddImageLayer_Name:(NSString*)layerName layerSize:(NSSize)layerSize layerOrigin:(NSPoint)layerOrigin layerOpacity:(int)opacity uniqueID:(NSString*)layerID compositeOp:(int)compositeOp preserveTransparency:(BOOL)preserveTr isClippingLayer:(BOOL)isClipping isVisble:(BOOL)isVisible fileArchitecture:(int)fileArchitecture layerRowBytes:(int)layerRowBytes architectureBytes:(unsigned char*)layerBytes layerCustomInfoDict:(NSDictionary*)layerCustomInfoDict hasLayerMask:(BOOL)hasLayerMask linkedWithMask:(BOOL)linkedWithMask maskVisible:(BOOL)maskVisible isEditingMask:(BOOL)editingMask maskSize:(NSSize)maskSize maskOrigin:(NSPoint)maskOrigin maskName:(NSString*)maskName maskID:(NSString*)maskID maskRowBytes:(int)maskRowBytes maskPixelsDataLength:(long)dataLength maskArchitectureBytes:(unsigned char*)maskPixelsBuffer layerMaskEdgeType:(long)layerMaskEdgeType layerMaskCustomInfoDict:(NSDictionary*)layerMaskCustomInfoDict;
-(NSError*)PXOS_PXM_AddTextLayer_Name:(NSString*)name layerSize:(NSSize)layerSize layerOrigin:(NSPoint)layerOrigin layerOpacity:(int)layerOpacity uniqueID:(NSString*)layerID compositeOp:(int)compositeOP preserveTransparency:(BOOL)preserveTr isClippingLayer:(BOOL)isClipping isVisble:(BOOL)visible fileArchitecture:(int)architecture layerRowBytes:(int)layerRowBytes architectureBytes:(unsigned char*)layerBytes textViewFrame:(NSRect)textViewFrame docZoomValue:(float)docZoom layerAttributedString:(NSAttributedString*)attributedString layerCustomInfoDict:(NSDictionary*)layerCustomInfoDict layerDrawOffsetPoint:(NSPoint)layerDrawOffsetPoint layerDrawCenter100:(long)layerDrawCenter100 hasLayerMask:(BOOL)haslayerMask linkedWithMask:(BOOL)linkedWithMask maskVisible:(BOOL)maskVisible isEditingMask:(BOOL)editingMask maskSize:(NSSize)maskSize maskOrigin:(NSPoint)maskOrigin maskName:(NSString*)maskName maskID:(NSString*)maskID maskRowBytes:(int)maskRowBytes maskPixelsDataLength:(long)maskDataLength maskArchitectureBytes:(unsigned char*)maskBytes layerMaskEdgeType:(long)layerMaskEdgeType layerMaskCustomInfoDict:(NSDictionary*)layerMaskCustomInfoDict;
-(NSError*)PXOS_PXM_LoadImage_ofImageSize:(NSSize)imageSize imageResolution:(float)imageResolution imageResolutionType:(int)resolutionType zoomValue:(float)zoomValue colorsyncProfileData:(NSData*)iccProfileData documentVisibleRect:(NSRect)imageVisibleRect masksInfo_selection:(NSIndexSet*)masksSelection masksVisibleRect:(NSRect)masksVisibleRect layersInfo_selection:(NSIndexSet*)layersSelection layersVisibleRect:(NSRect)layersVisibleRect keywordsList:(NSArray*)keywords customMetadataDict:(NSDictionary*)customMeta layersLinkingInfo:(NSDictionary*)llInfo;
//-------------
-(NSError*)PXOS_PXM_AddMask_Name:(NSString*)maskName layerSize:(NSSize)maskSize layerOrigin:(NSPoint)maskOrigin uniqueID:(NSString*)maskID fileArchitecture:(int)fArchitecture layerRowBytes:(long)maskRowBytes architectureBytes:(unsigned char*)bytesBuffer;
//--------- psd atidarymui ----------
-(NSError*)PXOSF_Open_PSD_LoadImage_Size:(NSSize)imageSize imageResolution:(float)resolution resolutionType:(int)resType colorSyncData:(NSData*)csProfileData filePropertiesDict:(NSDictionary*)propDict keywords:(NSArray*)keywordsList guidesInfo:(NSArray*)guidesInfo modeChangedToRGB:(BOOL)changed2RGB fileModeIsNotRGB:(BOOL)fileModeIsNotRGB;
-(NSError*)PXOSF_CreateNewTempDocument;
-(NSError*)PXOSF_FinalizeNewTempDocument;
//===================================================================================================================================
//===================================================================================================================================
// PDF atidarymui
//----------------------------------------------------------------
//-(NSError*)PXOS_LoadPDFImageWith_size:(NSSize)imageSize imageResolution:(float)imageResolution imageResolutionType:(int)resolutionType bytesPerRow:(unsigned int)bytesPerRow pixelsBuffer:(unsigned char*)rgbaPixelsBuffer filePropertiesDictionary:(NSDictionary*)propDict imageName:(NSString*)name;
//----------------------------------------------------------------
//-(BOOL)PXOS_loadAndPreparePDFCoverFlowBundle;
//----------------------------------------------------------------
//-(void)PXOS_SetPDFPagesAndLoadModal:(NSArray*)pdfPages;
//----------------------------------------------------------------
//-(void)PXOS_Open_PDF_addNewPageWithNSImage:(NSImage*)newNSImage imageID:(NSString*)imageID fullPath:(NSString*)imagePath;
//----------------------------------------------------------------
-(NSError*)PXOS_LoadNewPDFImageWith_size:(NSSize)imageSize imageResolution:(float)imageResolution imageResolutionType:(int)resolutionType bytesPerRow:(unsigned int)bytesPerRow pixelsBuffer:(unsigned char*)rgbaPixelsBuffer filePropertiesDictionary:(NSDictionary*)propDict imageName:(NSString*)name;
//----------------------------------------------------------------
//-(NSError*)PXOS_LoadIMImageWith_size:(NSSize)imageSize resolution:(double)resolution resolutionType:(int)resolutionType orientation:(int)orientation convertedToRGB:(BOOL)convertedToRGB colorProfileData:(NSData*)colorSyncData RGBApixels:(unsigned char*)rgbaPixels;
-(NSError*)PXOS_LoadIMImageWith_size:(NSSize)imageSize rowBytes:(size_t)rowBytes drawedToDeviceRGB:(BOOL)wasDrawedToDeviceRGB resolution:(double)resolution resolutionType:(int)resolutionType orientation:(int)orientation convertedToRGB:(BOOL)convertedToRGB fileIsNotRGBMode:(BOOL)fileIsNotRGBMode colorProfileData:(NSData*)colorSyncData RGBApixels:(unsigned char*)rgbaPixels;


//-------- PSD -----------

-(int)PXOSF_Open_PSD_Layer_CompositeOperatorFromPSDstring:(NSString*)stirngas;
-(void)PXOSF_Open_PSD_StartNewGroup;

-(NSError*)PXOS_PSD_AddLayerGroupWithSize:(NSSize)layerSize name:(NSString*)layerName isExpanded:(BOOL)expanded nativePixelsBuffer:(unsigned char*)layerBuffer rowBytes:(size_t)rowBytes layerOrigin:(NSPoint)layerOrigin layerOpacity:(unsigned char)layerOpacity compositeOP:(int)layerCompositeOp preserveTransparency:(BOOL)preserveTransparency isCLippingLayer:(BOOL)isClippingLayer isVisible:(BOOL)layerIsVisible linkedGroupID:(int)linkGroupID hasLayerMask:(BOOL)hasLayerMask isLinkedWithLayer:(BOOL)linkedWithMask maskIsVisible:(BOOL)maskIsVisible isEditingMask:(BOOL)editingMask maskSize:(NSSize)maskSize maskOrigin:(NSPoint)maskOrigin maskRowBytes:(size_t)maskRowBytes maskNativePixelsBuffer:(unsigned char*)maskNativePixelsBuffer;
-(NSError*)PXOS_PSD_AddLayerWithSize:(NSSize)layerSize name:(NSString*)layerName nativePixelsBuffer:(unsigned char*)layerBuffer rowBytes:(size_t)rowBytes layerOrigin:(NSPoint)layerOrigin layerOpacity:(unsigned char)layerOpacity compositeOP:(int)layerCompositeOp preserveTransparency:(BOOL)preserveTransparency isCLippingLayer:(BOOL)isClippingLayer isVisible:(BOOL)layerIsVisible linkedGroupID:(int)linkGroupID hasLayerMask:(BOOL)hasLayerMask isLinkedWithLayer:(BOOL)linkedWithMask maskIsVisible:(BOOL)maskIsVisible isEditingMask:(BOOL)editingMask maskSize:(NSSize)maskSize maskOrigin:(NSPoint)maskOrigin maskRowBytes:(size_t)maskRowBytes maskNativePixelsBuffer:(unsigned char*)maskNativePixelsBuffer;
-(CGColorSpaceRef)PXOS_CGColorSpaceRefFromNSData:(NSData*)profileData;

//===================================================================================================================================

//======= SAVE PART =========
-(BOOL)PXOSF_Save_ShouldUseExistingFile;
-(NSString*)PXOSF_Save_TempExistingFilePath;
-(NSSize)PXOSF_Save_ImageSize;
-(unsigned int)PXOSF_Save_BitsPerComponent;
-(unsigned int)PXOSF_Save_NumberOfComponents;
-(unsigned int)PXOSF_Save_BytesPerRow;
-(CGColorSpaceRef)PXOSF_Save_CGColorSpace;
-(BOOL)PXOSF_Should_Strip_ColorSpace;
-(BOOL)PXOSF_Save_hasTransparency;


-(size_t)PXOSF_Save_GetPremultipliedRGBABytesToBuffer:(unsigned char*)bytesBuffer atOffset:(size_t)bytesOffset count:(size_t)bytesCountToCopy;
-(NSDictionary*)PXOSF_Save_GetExifIptcDictionaryIncludingOriginalForUTI:(NSString*)fileUTI;
-(NSArray*)PXOSF_Save_GetDocumentKeywordsList;
-(NSData*)PXOSF_Save_GetDocumentColorSyncICCData;
-(double)PXOSF_Save_GetImageResolutionValue;
-(int)PXOSF_Save_GetImageResolutionType;
-(BOOL)PXOSF_Save_FillBuffer:(unsigned char*)pixelsBuffer withNativeRGBOpixelsForWidth:(size_t)iWidth andHeight:(size_t)iHeight;
-(NSData*)PXOSF_Save_GetIPTCKeywordsData;

-(long)PXOSF_Save_PXM_Preview_Width;
-(long)PXOSF_Save_PXM_Preview_Height;
-(long)PXOSF_Save_PXM_Preview_RowBytes;
-(NSData*)PXOSF_Save_PXM_Preview_NativePixelsData;
-(NSDictionary*)PXOSF_Save_PXM_GetRulersInfoDictionary;
-(BOOL)PXOSF_Save_PXM_RulersVisible;
-(long)PXOSF_Save_PXM_RulersMeasurementUnits;
-(NSPoint)PXOSF_Save_PXM_RulersOffset;
-(BOOL)PXOSF_Save_PXM_GridVisible;
-(BOOL)PXOSF_Save_PXM_SnapTo_Guides;
-(BOOL)PXOSF_Save_PXM_SnapTo_Grid;
-(BOOL)PXOSF_Save_PXM_SnapTo_Layers;
-(BOOL)PXOSF_Save_PXM_SnapTo_Bounds;
-(BOOL)PXOSF_Save_PXM_GuidesHidden;
-(BOOL)PXOSF_Save_PXM_GuidesLocked;
-(NSArray*)PXOSF_Save_PXM_GuidesArray;
-(long)PXOSF_Save_PXM_LayersCount;
-(NSSize)PXOSF_Save_PXM_LayerSizeAtIndex:(int)index;
-(NSPoint)PXOSF_Save_PXM_LayerOriginAtIndex:(int)index;
-(NSString*)PXOSF_Save_PXM_LayernameAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerVisibleAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerOpacityAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerBlendingModeAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerIsClippingAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerPreserveTransparencyAtIndex:(int)index;
-(NSString*)PXOSF_Save_PXM_LayerIDAtIndex:(int)index;
-(NSArray*)PXOSF_Save_PXM_LayerLinkedIndexesAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerIsTextAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerHasPixelDataAtIndex:(int)index;
-(NSAttributedString*)PXOSF_Save_PXM_LayerAttributedStringAtIndex:(int)index;
-(float)PXOSF_Save_PXM_DocumentZoom;
-(NSDictionary*)PXOSF_Save_PXM_CustomMetaDataDict;
-(NSDictionary*)PXOSF_Save_PXM_LayerCustomInfoDictAtIndex:(int)indexas;

-(NSRect)PXOSF_Save_PXM_LayerTextViewFrameAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerRowBytesAtIndex:(int)index;
-(NSData*)PXOSF_Save_PXM_LayerNativePixelsDataAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerLinkedWithmaskAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerHasMaskAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerMaskVisibleAtIndex:(int)index;
-(BOOL)PXOSF_Save_PXM_LayerIsEditingMaskAtIndex:(int)index;
-(NSSize)PXOSF_Save_PXM_LayerMaskSizeAtIndex:(int)index;
-(NSPoint)PXOSF_Save_PXM_LayerMaskOriginAtIndex:(int)index;
-(NSString*)PXOSF_Save_PXM_LayerMaskNameAtIndex:(int)index;
-(NSString*)PXOSF_Save_PXM_LayerMaskIDAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerMaskEdgeTypeAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerMaskRowBytesAtIndex:(int)index;
-(NSData*)PXOSF_Save_PXM_LayerMaskNativePixelsDataAtIndex:(int)index;
-(NSPoint)PXOSF_Save_PXM_LayerDrawOffsetPointAtIndex:(int)index;
-(long)PXOSF_Save_PXM_LayerCenterPointAtIndex:(int)index;

-(long)PXOSF_Save_PXM_MasksCount;
-(NSSize)PXOSF_Save_PXM_MaskSizeAtIndex:(int)indexas;
-(NSPoint)PXOSF_Save_PXM_MaskOriginAtIndex:(int)indexas;
-(NSString*)PXOSF_Save_PXM_MaskNameAtIndex:(int)indexas;
-(NSString*)PXOSF_Save_PXM_MaskIDAtIndex:(int)indexas;
-(long)PXOSF_Save_PXM_MaskRowBytesAtIndex:(int)indexas;
-(NSData*)PXOSF_Save_PXM_MaskNativePixelsDataAtIndex:(int)indexas;

-(BOOL)PXOSF_Save_PSD_UnpremultiplyLayers;
-(BOOL)PXOSF_Save_PSD_PremultiplyLayers;
-(long)PXOSF_Save_PSD_LayersCount;
-(NSPoint)PXOSF_Save_PSD_Layer_Origin_atIndex:(int)indexas;
-(NSSize)PXOSF_Save_PSD_Layer_Size_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Layer_HasLayerMask_atIndex:(int)indexas;
//-(NSSize)PXOSF_Save_PSD_Layer_MaskSize_atIndex:(int)indexas;
-(NSString*)PXOSF_Save_PSD_Layer_CompositeString_atIndex:(int)indexas;
-(int)PXOSF_Save_PSD_Layer_Opacity_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Layer_isClipping_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Layer_preserveTr_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Layer_visible_atIndex:(int)indexas;
-(NSString*)PXOSF_Save_PSD_Layer_name_atIndex:(int)indexas;
-(NSPoint)PXOSF_Save_PSD_Layer_Mask_Origin_atIndex:(int)indexas;
-(NSSize)PXOSF_Save_PSD_Layer_Mask_Size_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Layer_MaskVisible_atIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_Preview_GetBytesOfRGBAForChannel:(int)channel intoBuffer:(unsigned char*)buffer;
-(BOOL)PXOSF_Save_PSD_Layer_GetBytesOfLayerAtIndex:(int)indexas ofRGBAForChannel:(int)channel intoBuffer:(unsigned char*)buffer;
-(BOOL)PXOSF_Save_PSD_Layer_GetMaskBytesOfLayerAtIndex:(int)indexas intoBuffer:(unsigned char*)mbBuffer;
-(NSSize)PXOSF_Save_PSD_GetImageResolution;
-(int)PXOSF_Save_PSD_GetImageResolutionUnits;
-(NSArray*)PXOSF_Save_PSD_GuidesArray;
-(BOOL)PXOSF_Save_PSD_PrepareRasterizedVersionIfNeededAtIndex:(int)index;
-(BOOL)PXOSF_Save_PSD_RelaseRasterizedVersionIfNeededAtIndex:(int)index;
-(NSArray*)PXOSF_Save_PSD_LinkedLayersGroupsIDs;
-(BOOL)PXOSF_Save_PSD_LayerIsGroup_AtIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_LayerIsGroupEnd_AtIndex:(int)indexas;
-(BOOL)PXOSF_Save_PSD_LayerIsExpanded_AtIndex:(int)indexas;
-(BOOL)PXOSF_Save_TIFF_GetBytesOfRGB_IntoBuffer:(unsigned char**)buffer;
-(vImage_Buffer*)PXOSF_Save_RenderedABGRvImageBuffer;
-(int)PXOSF_Save_WebPQuality;
-(NSError*)PXOSF_Open_LoadGenericImageWithBGRAvImageBuffer:(vImage_Buffer*)bgraImageBuffer;

@optional
-(void)fileManager:(id)fileManager didReportSaveProgress:(float)percentDone;

@end
//===================================================================================================================================






///////// vidiniai protocolai

@protocol PXOS_FileOpenProtocol <NSObject>



@end


//// cia greitam atidarymui (drag&drop ir panasus).
@protocol PXOS_QuickOpenProtocol <NSObject>
-(NSError*)PXOSF_QO_ProcessInfo_bytesBuffer:(unsigned char*)bBuffer width:(unsigned int)width height:(unsigned int)height rowBytes:(size_t)rowBytes colorSpaceData:(NSData*)colorsyncData wasConvertedToGenericRGB:(BOOL)cobvertedToGenericRGB;
@end


