/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirInputField
extends FileInputField {
    private static final long serialVersionUID = 8494549823214831160L;
    private final boolean mustExist;
    private final boolean canCreate;

    public DirInputField(IzPanel izPanel, InstallData installData, boolean bl, String string, int n, List<ValidatorContainer> list, boolean bl2, boolean bl3) {
        super(izPanel, installData, bl, string, n, list, null, null);
        this.mustExist = bl2;
        this.canCreate = bl3;
    }

    @Override
    protected void prepareFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setFileSelectionMode(1);
    }

    @Override
    protected boolean _validate(File file) {
        System.err.println(file.getAbsolutePath() + " - isDir: " + file.isDirectory() + " - mustExist: " + this.mustExist + " - canCreate: " + this.canCreate);
        if (file.isDirectory()) {
            return true;
        }
        if (this.mustExist) {
            return false;
        }
        if (this.canCreate) {
            return this.verifyCreateOK(file);
        }
        return true;
    }

    @Override
    protected void showMessage(int n) {
        if (n == 0) {
            this.showMessage("dir.notdirectory");
        } else if (n == 1) {
            this.showMessage("dir.nodirectory");
        }
    }

    private boolean verifyCreateOK(File file) {
        if (!file.exists() && !this.parent.emitNotificationFeedback(this.parent.getI18nStringForClass("createdir", "TargetPanel") + "\n" + file.getAbsolutePath())) {
            return false;
        }
        if (!DirInputField.isWriteable(file)) {
            this.parent.emitError(this.parentFrame.langpack.getString("installer.error"), this.parent.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        return file.mkdirs();
    }

    private static boolean isWriteable(File file) {
        File file2 = IoHelper.existingParent(file);
        if (file2 == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File file3 = File.createTempFile("izWrTe", ".tmp", file2);
                file3.deleteOnExit();
            }
            catch (IOException iOException) {
                Debug.trace(iOException.toString());
                return false;
            }
            return true;
        }
        return file2.canWrite();
    }
}

