/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JSendmail {
    private static final int SMTP = 0;
    private static final int SMTPS = 1;
    private static Vector<String> ccList = new Vector();
    private static Vector<File> attachmentList = new Vector();
    private static String toAddr;
    private static String subject;
    private static String serverName;
    private static File messageFile;
    private static InputStream input;
    private static String username;
    private static String password;
    private static String fromAddress;
    private static String contentType;
    private static int serverPort;
    private static int smtpMode;
    private static final String[] SMTP_TITLE;

    static {
        serverPort = -1;
        smtpMode = 0;
        SMTP_TITLE = new String[]{"smtp", "smtps"};
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            JSendmail.printUsage("Too few arguments.");
        }
        int argIndex = 0;
        while (argIndex < args.length && serverName == null) {
            if (args[argIndex].equals("-f")) {
                ++argIndex;
                if (messageFile != null) {
                    JSendmail.printUsage("Only one instance of \"-f\" option allowed");
                    continue;
                }
                if (argIndex < args.length) {
                    messageFile = new File(args[argIndex]);
                    if (!messageFile.exists()) {
                        JSendmail.printUsage("-f filename <" + args[argIndex] + "> does not exist!");
                    }
                    ++argIndex;
                    continue;
                }
                JSendmail.printUsage("-f requires filename parameter");
                continue;
            }
            if (args[argIndex].equals("-s")) {
                ++argIndex;
                if (subject != null) {
                    JSendmail.printUsage("Only one instance of \"-s\" option allowed");
                    continue;
                }
                if (argIndex < args.length) {
                    subject = args[argIndex++];
                    continue;
                }
                JSendmail.printUsage("-s requires string parameter");
                continue;
            }
            if (args[argIndex].equals("-c")) {
                if (ccList.contains(args[++argIndex])) {
                    JSendmail.printUsage("CC address: " + args[argIndex] + " is specified more than once");
                    continue;
                }
                if (argIndex < args.length) {
                    String newAddr;
                    if ((newAddr = args[argIndex++]).indexOf(64) == -1) {
                        JSendmail.printUsage("CC address is invalid, must contain \"@\"");
                    }
                    ccList.add(newAddr);
                    continue;
                }
                JSendmail.printUsage("-c requires string parameter");
                continue;
            }
            if (args[argIndex].equals("-a")) {
                if (attachmentList.contains(args[++argIndex])) {
                    JSendmail.printUsage("attachment: " + args[argIndex] + " is specified more than once");
                    continue;
                }
                if (argIndex < args.length) {
                    File newAttachment = new File(args[argIndex]);
                    if (!newAttachment.exists()) {
                        JSendmail.printUsage("attachment: " + args[argIndex] + " does not exist.");
                    } else if (newAttachment.isDirectory()) {
                        JSendmail.printUsage("attachment: " + args[argIndex] + " must not be a directory.");
                    } else {
                        attachmentList.add(newAttachment);
                    }
                    ++argIndex;
                    continue;
                }
                JSendmail.printUsage("-a requires string parameter");
                continue;
            }
            if (args[argIndex].equals("-u")) {
                ++argIndex;
                if (username == null) {
                    if (argIndex < args.length) {
                        username = args[argIndex++];
                        continue;
                    }
                    JSendmail.printUsage("-u requires string parameter");
                    continue;
                }
                JSendmail.printUsage("-u may only be specified once");
                continue;
            }
            if (args[argIndex].equals("-p")) {
                ++argIndex;
                if (password == null) {
                    if (argIndex < args.length) {
                        password = args[argIndex++];
                        continue;
                    }
                    JSendmail.printUsage("-p requires string parameter");
                    continue;
                }
                JSendmail.printUsage("-p may only be specified once");
                continue;
            }
            if (args[argIndex].equals("-sp")) {
                ++argIndex;
                if (serverPort == -1) {
                    if (argIndex < args.length) {
                        try {
                            serverPort = Integer.parseInt(args[argIndex++]);
                        }
                        catch (Exception e) {
                            JSendmail.printUsage("-sp requires integer parameter");
                        }
                        continue;
                    }
                    JSendmail.printUsage("-sp requires integer parameter");
                    continue;
                }
                JSendmail.printUsage("-sp may only be specified once");
                continue;
            }
            if (args[argIndex].equals("-ct")) {
                if (++argIndex >= args.length) continue;
                contentType = args[argIndex++];
                continue;
            }
            if (args[argIndex].equals("-ssl")) {
                ++argIndex;
                if (smtpMode == 1) {
                    JSendmail.printUsage("-ssl may only be specified once");
                    continue;
                }
                smtpMode = 1;
                continue;
            }
            if (args[argIndex].equals("-from")) {
                ++argIndex;
                if (fromAddress == null) {
                    if (argIndex < args.length) {
                        fromAddress = args[argIndex++];
                        continue;
                    }
                    JSendmail.printUsage("-from requires string parameter");
                    continue;
                }
                JSendmail.printUsage("-from may only be specified once");
                continue;
            }
            if (toAddr == null) {
                if ((toAddr = args[argIndex++]).indexOf(64) != -1) continue;
                JSendmail.printUsage("send to address (" + toAddr + ") is invalid, must contain \"@\"");
                continue;
            }
            if (serverName != null) continue;
            serverName = args[argIndex++];
            if (fromAddress != null) continue;
            fromAddress = String.valueOf(System.getProperty("user.name")) + "@" + serverName;
        }
        if (messageFile != null) {
            try {
                input = new FileInputStream(messageFile);
            }
            catch (FileNotFoundException e) {
                JSendmail.printUsage("Unable to open file: " + messageFile.getPath());
            }
        } else {
            input = System.in;
        }
        if (username == null) {
            username = System.getProperty("user.name");
        }
        if (toAddr == null || serverName == null || username == null || password == null) {
            JSendmail.printUsage("Not enough arguments");
        }
        if (serverPort == -1) {
            serverPort = 25;
        }
        if (contentType == null) {
            contentType = "text/plain";
        }
        new JSendmail();
    }

    private static void printUsage(String reason) {
        System.out.println("JSendmail: " + reason);
        System.out.println("");
        System.out.println("JSendmail usage:");
        System.out.println("");
        System.out.println("");
        System.out.println(" JSendmail [-f filename] [-s \"str\"] [-c ccaddress] [-a attachment]");
        System.out.println("           [-from fromaddress] [-u username] [-p password]");
        System.out.println("           [-sp port] [-ssl] toaddress viaserver \"text\"");
        System.out.println("");
        System.out.println(" -f filename   - Specifies that the text of the message be read from the file \"filename\" instead");
        System.out.println("                 of standard input.");
        System.out.println(" -s \"str\"    - Specifies the subject of the email to be sent.");
        System.out.println(" -c ccaddress  - The email address of some to add to the CC list.");
        System.out.println(" -a attachment - The path of an attachment to add to the email.");
        System.out.println(" toaddress     - The email address to which the email will be sent.");
        System.out.println(" viaserver     - The hostname of the mail server via which the email will be sent.");
        System.out.println(" -u username   - the username with which to authenticate, defaults to currently logged in username.");
        System.out.println(" -p password   - the password with which to authenticate.");
        System.out.println(" -sp port      - the port number to connect with.");
        System.out.println(" -ssl          - Instructs jsendmail to use SSL when connecting to the SMTP server.");
        System.out.println(" -ct type      - the content type of the email, defaults to \"text/plain\"");
        System.out.println("");
        System.out.println(" \"text\"      - the actual text of the message as read from standard input.");
        System.out.println("");
        System.out.println("Note that if no -fromaddress option is specified, then the currently logged in username is used");
        System.out.println("in the form <username>@viaserver.");
        System.out.println("");
        System.exit(1);
    }

    private JSendmail() {
        String reason;
        boolean sent;
        block20: {
            Properties props = System.getProperties();
            props.put("mail." + SMTP_TITLE[smtpMode] + ".host", serverName);
            props.put("mail." + SMTP_TITLE[smtpMode] + ".auth", "true");
            props.put("mail.smtp.connectiontimeout", "120000");
            props.put("mail.smtp.timeout", "120000");
            props.put("mail.smtp.starttls.enable", "true");
            sent = false;
            reason = null;
            Session session = Session.getInstance(props, new SMTPAuthenticator(username, password));
            MimeMessage msg = new MimeMessage(session);
            try {
                try {
                    ((Message)msg).addFrom(new Address[]{new InternetAddress(fromAddress, fromAddress.substring(0, fromAddress.indexOf(64)))});
                    msg.addRecipient(Message.RecipientType.TO, new InternetAddress(toAddr, toAddr.substring(0, toAddr.indexOf(64))));
                    ((Message)msg).setReplyTo(new Address[]{new InternetAddress(fromAddress, fromAddress.substring(0, fromAddress.indexOf(64)))});
                    if (subject != null) {
                        ((Message)msg).setSubject(subject);
                    }
                    if (ccList.size() > 0) {
                        int i = 0;
                        while (i < ccList.size()) {
                            String ccAddr = ccList.elementAt(i);
                            msg.addRecipient(Message.RecipientType.CC, new InternetAddress(ccAddr, ccAddr.substring(0, ccAddr.indexOf(64))));
                            ++i;
                        }
                    }
                    ((Message)msg).setSentDate(new Date());
                    byte[] bytes = new byte[input.available()];
                    input.read(bytes, 0, input.available());
                    if (attachmentList.isEmpty()) {
                        msg.setContent(new String(bytes), contentType);
                    } else {
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        messageBodyPart.setContent(new String(bytes), contentType);
                        MimeMultipart multipart = new MimeMultipart();
                        ((Multipart)multipart).addBodyPart(messageBodyPart);
                        int i = 0;
                        while (i < attachmentList.size()) {
                            messageBodyPart = new MimeBodyPart();
                            FileDataSource source = new FileDataSource(attachmentList.elementAt(i));
                            messageBodyPart.setDataHandler(new DataHandler(source));
                            messageBodyPart.setFileName(attachmentList.elementAt(i).getName());
                            messageBodyPart.setHeader("Content-ID", "<attachment" + Integer.toString(i).trim() + ">");
                            ((Multipart)multipart).addBodyPart(messageBodyPart);
                            ++i;
                        }
                        msg.setContent(multipart);
                    }
                    ((Message)msg).saveChanges();
                    Transport trans = session.getTransport(SMTP_TITLE[smtpMode]);
                    try {
                        trans.connect(serverName, serverPort, username, password);
                        trans.sendMessage(msg, ((Message)msg).getAllRecipients());
                    }
                    finally {
                        trans.close();
                    }
                    sent = true;
                }
                catch (UnsupportedEncodingException e1) {
                    sent = false;
                    reason = e1.getMessage();
                }
                catch (IOException e) {
                    sent = false;
                    reason = e.getMessage();
                }
            }
            catch (AddressException e) {
                sent = false;
                reason = e.getMessage() != null ? e.getMessage().trim() : (e.toString() != null ? e.toString() : "Unknown");
                if (e.getCause() != null) {
                    reason = String.valueOf(reason) + "\n" + e.getCause().getMessage().trim();
                }
            }
            catch (MessagingException e) {
                sent = false;
                reason = e.getMessage() != null ? e.getMessage().trim() : (e.toString() != null ? e.toString() : "Unknown");
                if (e.getNextException() != null && e.getNextException().getMessage() != null) {
                    reason = String.valueOf(reason) + "\n" + e.getNextException().getMessage().trim();
                }
                if (e.getCause() == null) break block20;
                reason = String.valueOf(reason) + "\n" + e.getCause().getMessage().trim();
            }
        }
        if (!sent) {
            System.out.println("JSendmail unable to send: " + reason);
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public class SMTPAuthenticator
    extends Authenticator {
        private PasswordAuthentication authentic;

        public SMTPAuthenticator(String username, String password) {
            this.authentic = new PasswordAuthentication(username, password);
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.authentic;
        }
    }
}

