//
//  PXILResize.h
//  PXImageLib
//
//  Created by Aidas Dailide on 2008-10-23.
//  Copyright 2008 Pixelmator Team Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Accelerate/Accelerate.h>

typedef enum PXILResizeInterpolationModes
	{
		PXILResizeNearestNeighbor,
		PXILResizeLinear,
		PXILResizeCubic,
		PXILResizeSupersample,
		PXILResizeLanczos3,
		PXILResizeLanczos5,
		PXILResizeAppleLanczos3
	} PXILResizeInterpolationMode;

@interface PXILResize : NSObject {

}

+(PXILResize *)sharedInstance;
-(BOOL)imageLibScaleRGBA8888:( const vImage_Buffer *)src destination:(const vImage_Buffer *)dest interpolationMode:(PXILResizeInterpolationMode)iMode;
-(BOOL)imageLibScalePlanar8:( const vImage_Buffer *)src destination:(const vImage_Buffer *)dest interpolationMode:(PXILResizeInterpolationMode)iMode;
-(BOOL)imageLibAffineWarpIntelPlanar8:( const vImage_Buffer *)src destination:(const vImage_Buffer *)dest interpolationMode:(PXILResizeInterpolationMode)iMode transform:(vImage_AffineTransform)tr;
-(BOOL)imageLibRotateIntelPlanar8:( const vImage_Buffer *)src destination:(const vImage_Buffer *)dest interpolationMode:(PXILResizeInterpolationMode)iMode angle:(float)angle;
-(BOOL)imageLibScaleRGBA8888:(const vImage_Buffer *)src destination:(const vImage_Buffer *)dest interpolationMode:(PXILResizeInterpolationMode)iMode sourceROI:(NSRect)sourceROI destinationROI:(NSRect)destinationROI bufferCallback:(SEL)bufferCallback owner:(id)owner;
@end
