/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.jdesktop.swingworker.SwingWorker;

public class WebDownloadPanel
extends IzPanel {
    public static final String OS_LINUX = "linux";
    public static final String OS_MAC = "mac";
    public static final String OS_WINDOWS = "windows";
    private static final long serialVersionUID = 3257848774955903587L;
    private JLabel pluginsAACLabel;
    private JProgressBar pb;
    private SwingWorker downloadTask;
    private boolean canceled = false;

    public WebDownloadPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public WebDownloadPanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        JLabel welcomeLabel = LabelFactory.create(idata.langpack.getString("webdownload.title"));
        this.add((Component)welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        this.pb = new JProgressBar(0, 100);
        this.pb.setStringPainted(true);
        this.add((Component)this.pb, "nextLine");
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        boolean pluginsAAC = false;
        try {
            pluginsAAC = Boolean.valueOf(this.idata.getVariable("ultramixer.plugins.aac.install"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showUnspecifiedErrorMessage();
            return;
        }
        if (pluginsAAC) {
            boolean succ;
            this.pb.setIndeterminate(true);
            this.parent.lockNextButton();
            String[] remoteFiles = this.getRemoteFilesForOS();
            String localDir = this.idata.getInstallPath().concat(File.separator).concat(this.idata.getVariable("ultramixer.plugins.dir"));
            File localDirF = new File(localDir);
            if (!localDirF.exists() && !(succ = localDirF.mkdir())) {
                Frame rootFrame = JFrame.getFrames()[0];
                String msg = this.idata.langpack.getString("webdownload.failed_creating_install_dir.msg");
                msg = msg.replace("$1", localDir);
                String title = this.idata.langpack.getString("webdownload.failed_creating_install_dir.title");
                JOptionPane.showMessageDialog(rootFrame, msg, title, 0);
                return;
            }
            this.downloadTask = this.downloadFiles(remoteFiles, localDir);
            this.downloadTask.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("TASK_CURRENT_FILE")) {
                        String currentFile = (String)evt.getNewValue();
                        WebDownloadPanel.this.pb.setValue(0);
                        String msg = ((WebDownloadPanel)WebDownloadPanel.this).idata.langpack.getString("webdownload.progressbar.msg");
                        msg = msg.replace("$1", currentFile);
                        WebDownloadPanel.this.pb.setString(msg);
                    } else if (evt.getPropertyName().equals("TASK_PROGRESS")) {
                        int progress = (Integer)evt.getNewValue();
                        WebDownloadPanel.this.pb.setIndeterminate(false);
                        WebDownloadPanel.this.pb.setValue(progress);
                    } else if (evt.getPropertyName().equals("TASK_DONE")) {
                        WebDownloadPanel.this.parent.unlockNextButton();
                        Boolean succ = (Boolean)evt.getNewValue();
                        if (succ.booleanValue()) {
                            WebDownloadPanel.this.parent.navigateNext();
                        } else {
                            WebDownloadPanel.this.showUnspecifiedErrorMessage();
                            WebDownloadPanel.this.parent.navigateNext();
                        }
                    } else if (evt.getPropertyName().equals("TASK_EXCEPTION")) {
                        Exception ex = (Exception)evt.getNewValue();
                        if (ex instanceof UnknownHostException) {
                            WebDownloadPanel.this.showNoInternetConnectionMessage();
                            WebDownloadPanel.this.parent.navigatePrevious();
                        } else {
                            WebDownloadPanel.this.showUnspecifiedErrorMessage();
                            WebDownloadPanel.this.parent.unlockNextButton();
                        }
                    }
                }
            });
            this.downloadTask.execute();
        } else {
            this.parent.skipPanel();
        }
    }

    public void panelDeactivate() {
        if (this.downloadTask != null && !this.downloadTask.isDone()) {
            this.downloadTask.cancel(true);
            this.canceled = true;
        }
    }

    private String[] getRemoteFilesForOS() {
        String aacFiles = this.idata.getVariable("ultramixer.plugins.aac.files");
        String[] aacFilesA = aacFiles.split(";");
        return aacFilesA;
    }

    public SwingWorker downloadFiles(final String[] remoteFiles, final String localDir) {
        SwingWorker sw = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                for (String remoteFile : remoteFiles) {
                    if (this.isCancelled() || WebDownloadPanel.this.canceled) {
                        this.firePropertyChange("TASK_DONE", false, false);
                        return false;
                    }
                    String localFileName = remoteFile.substring(remoteFile.lastIndexOf("/") + 1);
                    String localFile = localDir.concat(File.separator).concat(localFileName);
                    this.firePropertyChange("TASK_CURRENT_FILE", null, localFileName);
                    OutputStream out = null;
                    URLConnection conn = null;
                    InputStream in = null;
                    try {
                        int numRead;
                        URL url = new URL(remoteFile);
                        out = new BufferedOutputStream(new FileOutputStream(localFile));
                        conn = url.openConnection();
                        conn.setConnectTimeout(5000);
                        HttpURLConnection h = (HttpURLConnection)conn;
                        int length = h.getContentLength();
                        h.setConnectTimeout(5000);
                        in = h.getInputStream();
                        byte[] buffer = new byte[1024];
                        long numWritten = 0L;
                        while ((numRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, numRead);
                            double percent = (double)(numWritten += (long)numRead) * 100.0 / (double)length;
                            this.firePropertyChange("TASK_PROGRESS", -1, (int)percent);
                        }
                    }
                    catch (Exception e) {
                        this.firePropertyChange("TASK_EXCEPTION", null, e);
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ioe) {
                            this.firePropertyChange("TASK_EXCEPTION", null, ioe);
                            return false;
                        }
                    }
                }
                this.firePropertyChange("TASK_DONE", false, true);
                return true;
            }
        };
        return sw;
    }

    private void showNoInternetConnectionMessage() {
        Frame rootFrame = JFrame.getFrames()[0];
        String msg = this.idata.langpack.getString("webdownload.no_internetconnection_error.msg");
        msg = "<html><div style=\"width: 300px;\">" + msg + "</div></html>";
        String title = this.idata.langpack.getString("webdownload.no_internetconnection_error.title");
        JOptionPane.showMessageDialog(rootFrame, msg, title, 0);
    }

    private void showUnspecifiedErrorMessage() {
        Frame rootFrame = JFrame.getFrames()[0];
        String msg = this.idata.langpack.getString("webdownload.unspecified_error.msg");
        msg = "<html><div style=\"width: 300px;\">" + msg + "</div></html>";
        String title = this.idata.langpack.getString("webdownload.unspecified_error.title");
        JOptionPane.showMessageDialog(rootFrame, msg, title, 0);
    }

    public static void main(String[] args) {
        String file = "http://ultramixer.com/_releases/plugins/aac/codec_aac.dll";
        String localFile = "F:/".concat(File.separator).concat("codec_aac_downloaded.dll");
    }
}

